<?php
/*
	DevSaver Web Framework
	Copyright (c) 2002-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com
*/

if (!defined("STPBase")) {
	die("This file can't be accessed directly!");
}
// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CDir{
	
	var $tplvars; 

	function __construct(
			$path , 
			$ext = "",
			$recursive = false
	) {
		$this->path = $path;
		$this->ext = $ext;
		$this->recursive = $recursive;

		$this->__readDir($path);
		
		return $this->_files;
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function __readDir($path) {
		$d = dir($path);
		while (false !== ($entry = $d->read())) {

			if ($this->recursive && is_dir($path . "/" . $entry))
				$this->__readDir($path . "/" . $entry);	

			if (!is_dir($path . "/" . $entry)) {
				if ((($this->ext != "") && strstr($entry , $this->ext)) || ($this->ext == "")) {			
						$this->_files[] = $path . "/" . $entry;
				}
			}
		}
		$d->close();
	}	


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	static function GetFiles($dir , $ext = false  , $keywords = "") {

		$files = CDir::__getfiles($dir , false , $ext , $keywords);
		//sort alphabeticaly
		sort($files);
		return $files ;
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function DeleteFiles($dir , $ext) {
		$files = CDIR::GetFiles($dir, $ext);

		if (is_array($files)) {
			foreach ($files as $key => $val) {
				CFile::Remove($val);
			}			
		}
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	static function GetFilesRec($dir , $ext = false , $keyword = "") {
		return CDir::__getfiles($dir , TRUE , $ext , $keyword) ;
	}

	static function GetFolders($dir) {

		$array = array();
		$d = dir($dir);
		while (false !== ($entry = $d->read())) {
		  if($entry!='.' && $entry!='..') {

			  if(is_dir($dir . $entry)) {
				$array[$entry ] =  $entry ;
			  } 
		  }
		}
		$d->close();
		return $array;

	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	static function __getfiles($dir , $rec = TRUE , $ext , $keyword) {
		$array = array();
		$d = dir($dir);
		while (false !== ($entry = $d->read())) {
		  if($entry!='.' && $entry!='..') {
			  $entry = $dir.'/'.$entry;
			  if(is_dir($entry)) {
				  if ($rec == true)
					//$array[] = $entry;
					$array = array_merge($array, CDir::__getfiles($entry , $rec , $ext , $keyword));
			  } else {
				  if (($ext && stristr($entry , $ext )) || !$ext) {

					  if ($keyword) {
						if (stristr($entry , $keyword)) {
						  $array[] = $entry;
						}
												 
					  } else {					  
						  $array[] = $entry;
					  }
				  }				  
			  }
		  }
		}
		$d->close();
		return $array;

	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	static function Make($dir , $code = 0755) {

		if (!is_dir($dir)) {
			mkdir($dir , $code);
		}
		
	}


	public static function Delete($dir) { 
		$files = array_diff(scandir($dir), array('.','..')); 

		foreach ($files as $file) { 
		  (is_dir("$dir/$file")) ? CDir::Delete("$dir/$file") : unlink("$dir/$file"); 
		} 
		return rmdir($dir); 
	} 
	
}

?>